<?php
/**
 * CORS Utility Class
 * Handles Cross-Origin Resource Sharing headers
 */

class CORS {
    /**
     * Set CORS headers
     */
    public static function setHeaders() {
        // Get allowed origins from config
        $configuredOrigins = defined('CORS_ALLOWED_ORIGINS') ? CORS_ALLOWED_ORIGINS : '*';
        $allowedMethods = defined('CORS_ALLOWED_METHODS') ? CORS_ALLOWED_METHODS : 'GET, POST, PUT, DELETE, OPTIONS';
        $allowedHeaders = defined('CORS_ALLOWED_HEADERS') ? CORS_ALLOWED_HEADERS : 'Content-Type, Authorization, X-Requested-With, Accept, Origin, Referer, User-Agent';
        
        // Get the origin from the request
        $originHeader = $_SERVER['HTTP_ORIGIN'] ?? '';
        
        // Resolve allowed origin dynamically (supports comma-separated list)
        $allowedOriginHeader = '*';
        if ($configuredOrigins !== '*') {
            $allowedOrigins = array_map('trim', explode(',', $configuredOrigins));
            if (!empty($originHeader) && in_array($originHeader, $allowedOrigins, true)) {
                $allowedOriginHeader = $originHeader;
            } elseif (!empty($allowedOrigins)) {
                // If origin doesn't match, use first allowed origin (for development)
                $allowedOriginHeader = $allowedOrigins[0];
            }
        } else {
            // If configured as '*', use the request origin if present
            $allowedOriginHeader = !empty($originHeader) ? $originHeader : '*';
        }
        
        // Set CORS headers
        header("Access-Control-Allow-Origin: {$allowedOriginHeader}");
        header("Access-Control-Allow-Methods: {$allowedMethods}");
        header("Access-Control-Allow-Headers: {$allowedHeaders}");
        
        if ($allowedOriginHeader !== '*') {
            header("Access-Control-Allow-Credentials: true");
        }
        header("Access-Control-Max-Age: 86400"); // 24 hours
    }
    
    /**
     * Handle preflight OPTIONS request
     */
    public static function handlePreflight() {
        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            self::setHeaders();
            http_response_code(200);
            exit;
        }
    }
}

