<?php
/**
 * User Model
 * Handles all database operations for users table
 */

class UserModel {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }
    
    /**
     * Find user by username or email
     * @param string $identifier Username or email
     * @return array|false User data or false if not found
     */
    public function findByUsernameOrEmail($identifier) {
        $stmt = $this->db->prepare("SELECT id, username, email, password, role FROM users WHERE username = ? OR email = ?");
        $stmt->execute([$identifier, $identifier]);
        return $stmt->fetch();
    }
    
    /**
     * Update user token
     * @param int $userId User ID
     * @param string $token Authentication token
     * @return bool True on success
     */
    public function updateToken($userId, $token) {
        $stmt = $this->db->prepare("UPDATE users SET token = ? WHERE id = ?");
        return $stmt->execute([$token, $userId]);
    }
    
    /**
     * Clear user token (logout)
     * @param int $userId User ID
     * @return bool True on success
     */
    public function clearToken($userId) {
        $stmt = $this->db->prepare("UPDATE users SET token = NULL WHERE id = ?");
        return $stmt->execute([$userId]);
    }
    
    /**
     * Get user by ID
     * @param int $userId User ID
     * @return array|false User data or false if not found
     */
    public function findById($userId) {
        $stmt = $this->db->prepare("SELECT id, username, email, role, created_at FROM users WHERE id = ?");
        $stmt->execute([$userId]);
        return $stmt->fetch();
    }
}

