<?php
/**
 * Authentication Middleware
 * Validates JWT tokens and authenticates requests
 */

require_once __DIR__ . '/../utils/Response.php';

class AuthMiddleware {
    /**
     * Verify authentication token
     * @return array User data if authenticated
     */
    public static function verify() {
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? $headers['authorization'] ?? '';
        
        // Check if Authorization header exists
        if (empty($authHeader)) {
            Response::unauthorized('Authorization token required');
        }
        
        // Extract token from "Bearer {token}" format
        if (!preg_match('/Bearer\s+(.*)$/i', $authHeader, $matches)) {
            Response::unauthorized('Invalid authorization header format');
        }
        
        $token = $matches[1];
        
        // Verify token in database
        try {
            $db = Database::getInstance()->getConnection();
            $stmt = $db->prepare("SELECT id, username, email, role FROM users WHERE token = ? AND token IS NOT NULL");
            $stmt->execute([$token]);
            $user = $stmt->fetch();
            
            if (!$user) {
                Response::unauthorized('Invalid or expired token');
            }
            
            // Return user data for use in controllers
            return $user;
        } catch (PDOException $e) {
            Response::serverError('Authentication verification failed');
        }
    }
    
    /**
     * Check if user has required role
     * @param array $user User data from verify()
     * @param array $allowedRoles Allowed roles
     * @return bool True if user has required role
     */
    public static function hasRole($user, $allowedRoles) {
        return in_array($user['role'], $allowedRoles);
    }
}

