<?php
/**
 * API Entry Point
 * Main router file that handles all API requests
 */

// Start output buffering
ob_start();

// Load configuration files
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/config/database.php';

// Load utility classes
require_once __DIR__ . '/utils/Response.php';
require_once __DIR__ . '/utils/Validator.php';
require_once __DIR__ . '/utils/CORS.php';

// Load middleware
require_once __DIR__ . '/middleware/AuthMiddleware.php';

// Load models
require_once __DIR__ . '/models/UserModel.php';
require_once __DIR__ . '/models/PatientModel.php';
require_once __DIR__ . '/models/DoctorModel.php';
require_once __DIR__ . '/models/StaffModel.php';
require_once __DIR__ . '/models/CaseSheetModel.php';
require_once __DIR__ . '/models/CategoryModel.php';

// Load controllers
require_once __DIR__ . '/controllers/AuthController.php';
require_once __DIR__ . '/controllers/PatientController.php';
require_once __DIR__ . '/controllers/DoctorController.php';
require_once __DIR__ . '/controllers/StaffController.php';
require_once __DIR__ . '/controllers/CaseSheetController.php';
require_once __DIR__ . '/controllers/CategoryController.php';

// Load routes
require_once __DIR__ . '/routes/api.php';

// Handle CORS
CORS::setHeaders();
CORS::handlePreflight();

// Initialize router and dispatch request
try {
    $router = new Router();
    $router->registerRoutes();
    $router->dispatch();
} catch (Exception $e) {
    Response::serverError('An error occurred: ' . $e->getMessage());
}

// Clean output buffer
ob_end_flush();

