<?php
/**
 * Database Configuration and Connection
 * Uses PDO for secure database operations
 */

class Database {
    private static $instance = null;
    private $connection = null;
    
    // Database credentials
    // private const DB_HOST = 'localhost';
    // private const DB_NAME = 'samanwaya_db';
    // private const DB_USER = 'root';
    // private const DB_PASS = '';
    // private const DB_CHARSET = 'utf8mb4';

    //Production Database credentials
    private const DB_HOST_PROD = 'localhost';
    private const DB_NAME_PROD = 'sumioypw_samanwaya_db';
    private const DB_USER_PROD = 'sumioypw_samanway_sa';
    private const DB_PASS_PROD = 'rolF9KpnBWuH';
    private const DB_CHARSET_PROD = 'utf8mb4';
    
    /**
     * Private constructor to prevent direct instantiation
     * Implements Singleton pattern for database connection
     */
    private function __construct() {
        try {
            $dsn = "mysql:host=" . self::DB_HOST . ";dbname=" . self::DB_NAME . ";charset=" . self::DB_CHARSET;
            
            $options = [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => false,
                PDO::ATTR_PERSISTENT         => false
            ];
            
            $this->connection = new PDO($dsn, self::DB_USER, self::DB_PASS, $options);
        } catch (PDOException $e) {
            // Log error in production, show message in development
            if (defined('ENVIRONMENT') && ENVIRONMENT === 'development') {
                die("Database Connection Failed: " . $e->getMessage());
            } else {
                die("Database connection failed. Please contact administrator.");
            }
        }
    }
    
    /**
     * Get singleton instance of Database
     * @return Database
     */
    public static function getInstance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Get PDO connection
     * @return PDO
     */
    public function getConnection() {
        return $this->connection;
    }
    
    /**
     * Prevent cloning of the instance
     */
    private function __clone() {}
    
    /**
     * Prevent unserialization of the instance
     */
    public function __wakeup() {
        throw new Exception("Cannot unserialize singleton");
    }
}

