<?php
/**
 * Application Configuration
 * Contains all application-wide settings
 */

// Environment: 'development' or 'production'
define('ENVIRONMENT', 'development');

// Error Reporting
if (ENVIRONMENT === 'development') {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Timezone
date_default_timezone_set('Asia/Kolkata');

// Base URL Configuration
define('BASE_URL', 'https://api.samanwaya.com');
define('API_BASE_URL', BASE_URL . '/api');

// JWT Configuration
define('JWT_SECRET', 'your-secret-key-change-in-production-min-32-chars');
define('JWT_ALGORITHM', 'HS256');
define('JWT_EXPIRATION', 86400); // 24 hours in seconds

// CORS Configuration
define('CORS_ALLOWED_ORIGINS', 'https://admin.samanwaya.com'); // Comma-separated list for multiple origins
define('CORS_ALLOWED_METHODS', 'GET, POST, PUT, DELETE, OPTIONS');
define('CORS_ALLOWED_HEADERS', 'Content-Type, Authorization, X-Requested-With, Accept, Origin, Referer, User-Agent, sec-ch-ua, sec-ch-ua-mobile, sec-ch-ua-platform, sec-fetch-dest, sec-fetch-mode, sec-fetch-site');

// Pagination
define('DEFAULT_PAGE_SIZE', 20);
define('MAX_PAGE_SIZE', 100);

// File Upload Settings (if needed in future)
define('MAX_UPLOAD_SIZE', 5242880); // 5MB in bytes
define('ALLOWED_FILE_TYPES', ['jpg', 'jpeg', 'png', 'pdf']);

